
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

/**
 * SoundtrackMusicGUI.java
 * @author Lunaqua
 * @credits yess
 * Main frame for Soundtrack Music Manager
 */
public class SoundtrackMusicGUI extends javax.swing.JFrame {

    private Junction junc;
    private Soundtrack st;
    private File curAddDir;
    private boolean enableJunc = true;


    /** Creates new form SoundtrackMusicGUI */
    public SoundtrackMusicGUI(){
        initComponents();

        try {junc = new Junction(TextArea);}
        catch (Exception ex) {Logger.getLogger(SoundtrackMusicGUI.class.getName()).log(Level.SEVERE, null, ex);}
        st = new Soundtrack(TextArea);

        if(st.getWrongFolder()){
            JOptionPane.showMessageDialog(this,
                    "Soundtrack addon is not in World of Warcraft\\Interface\\Addons.\n\n" +
                    "Soundtrack is in " + st.getAddonDir() + ".\n\n" +
                    "Please move to the correct folder, then run Soundtrack Music Manager.",
                    "Soundtrack in wrong folder", JOptionPane.ERROR_MESSAGE);
            System.exit(0);
        }
        JOptionPane.showMessageDialog(this, "Welcome to Soundtrack Music Manager!\n\n" +
                "Junctions enabled.\n\nClick Options to change.\n" +
                "Click Help for more information about Junctions.");

        /*String curDir = System.getProperty("user.dir");
        String linkname = curDir + "\\j-SoundtrackMusic";
        File link = new File(linkname);
        try {
            if(!link.exists()){
                junc.createlink(curDir + "\\j-SoundtrackMusic", st.getMusicDir().getPath());
            }
        } catch (IOException ex) {
            Logger.getLogger(SoundtrackMusicGUI.class.getName()).log(Level.SEVERE, null, ex);
        }*/
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        ScrollPanel = new javax.swing.JScrollPane();
        TextArea = new javax.swing.JTextArea();
        MenuBar = new javax.swing.JMenuBar();
        DeleteFiles = new javax.swing.JMenu();
        AddFile = new javax.swing.JMenuItem();
        AddFolder = new javax.swing.JMenuItem();
        jSeparator2 = new javax.swing.JSeparator();
        DeleteFile = new javax.swing.JMenuItem();
        DeleteFolder = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JSeparator();
        CreateSoundtrackMusic = new javax.swing.JMenuItem();
        FileMenuSeparator = new javax.swing.JSeparator();
        ExitManager = new javax.swing.JMenuItem();
        OptionsMenu = new javax.swing.JMenu();
        EnableJunctions = new javax.swing.JCheckBoxMenuItem();
        HelpMenu = new javax.swing.JMenu();
        AboutJunctions = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Soundtrack Music Manager");
        setFocusCycleRoot(false);
        setForeground(java.awt.Color.white);
        setLocationByPlatform(true);

        TextArea.setColumns(20);
        TextArea.setEditable(false);
        TextArea.setRows(5);
        TextArea.setText("Soundtrack Music Manager\n  Created by Lunaqua\n  Source Code by Yess (Epic Music Player)\n\nSoundtrack: Music Addon for World of Warcraft\n  Created by Morricone\n  Maintenance by FluffyBearLina\n  Maintained by Lunaqua\n\nFound at:\nhttp://wow.curse.com/downloads/wow-addons/details/soundtrack.aspx\n\n");
        ScrollPanel.setViewportView(TextArea);

        DeleteFiles.setText("File");

        AddFile.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Icons/Add File.png"))); // NOI18N
        AddFile.setText("Add MP3 File(s)");
        AddFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                AddFileActionPerformed(evt);
            }
        });
        DeleteFiles.add(AddFile);

        AddFolder.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Icons/Add Folder.png"))); // NOI18N
        AddFolder.setText("Add Music Folder(s)");
        AddFolder.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                AddFolderActionPerformed(evt);
            }
        });
        DeleteFiles.add(AddFolder);
        DeleteFiles.add(jSeparator2);

        DeleteFile.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Icons/Delete File.png"))); // NOI18N
        DeleteFile.setText("Delete MP3 File(s)");
        DeleteFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                DeleteFileActionPerformed(evt);
            }
        });
        DeleteFiles.add(DeleteFile);

        DeleteFolder.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Icons/Delete Folder.png"))); // NOI18N
        DeleteFolder.setText("Delete Music Folder(s)");
        DeleteFolder.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                DeleteFolderActionPerformed(evt);
            }
        });
        DeleteFiles.add(DeleteFolder);
        DeleteFiles.add(jSeparator1);

        CreateSoundtrackMusic.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Icons/Add SoundtrackMusic Folder.png"))); // NOI18N
        CreateSoundtrackMusic.setText("Create SoundtrackMusic Folder");
        CreateSoundtrackMusic.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                CreateSoundtrackMusicActionPerformed(evt);
            }
        });
        DeleteFiles.add(CreateSoundtrackMusic);
        DeleteFiles.add(FileMenuSeparator);

        ExitManager.setText("Exit Manager");
        ExitManager.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ExitManagerActionPerformed(evt);
            }
        });
        DeleteFiles.add(ExitManager);

        MenuBar.add(DeleteFiles);

        OptionsMenu.setText("Options");

        EnableJunctions.setSelected(true);
        EnableJunctions.setText("Enable Junctions");
        EnableJunctions.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                EnableJunctionsActionPerformed(evt);
            }
        });
        OptionsMenu.add(EnableJunctions);

        MenuBar.add(OptionsMenu);

        HelpMenu.setText("Help");

        AboutJunctions.setText("About Junctions");
        AboutJunctions.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                AboutJunctionsActionPerformed(evt);
            }
        });
        HelpMenu.add(AboutJunctions);

        MenuBar.add(HelpMenu);

        setJMenuBar(MenuBar);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(ScrollPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 537, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(ScrollPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 285, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents


    private void AddFolderActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_AddFolderActionPerformed
        JFileChooser jf = new JFileChooser();
        jf.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        jf.setMultiSelectionEnabled(true);
        if(curAddDir == null){
            jf.setCurrentDirectory(curAddDir);
        }
        int returnVal = jf.showOpenDialog(this);
        curAddDir = jf.getCurrentDirectory();
        File[] files = jf.getSelectedFiles();

        st.resetCounts();
        int junccount = 0;
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            if(enableJunc){  // Create junctions to each folder
                try {
                    for(int i=0; i < files.length; i++){
                        File destf = new File(st.getMusicDir() + "\\" + files[i].getName());
                        String linkname = destf.getParentFile() + "\\j-" + destf.getName();
                        junc.createlink(linkname, files[i].getPath());
                        st.Log("Creating junction to " + destf.getPath());
                        junccount++;
                    }
                } catch (IOException ex) {
                    Logger.getLogger(SoundtrackMusicGUI.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if(!enableJunc){
                for (int i = 0; i < files.length; i++){
                    File f = files[i];
                    String psrcpath = f.getPath();
                    String musDirName = f.getName();
                    String destpath = st.getMusicDir().getPath() + "\\" + musDirName;
                    st.CopyAddFiles(psrcpath, destpath);
                }
            }
        }
        if(junccount > 0){
            st.Log("Summary: Added " + junccount + " junction(s).\n");
        } else{
            st.Log("Summary: Added " + st.getmp3count() + " mp3 file(s).\n");
        }
    }//GEN-LAST:event_AddFolderActionPerformed

    private void ExitManagerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ExitManagerActionPerformed
        System.exit(0);
    }//GEN-LAST:event_ExitManagerActionPerformed

    private void EnableJunctionsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_EnableJunctionsActionPerformed
        if(EnableJunctions.isSelected()){
            enableJunc = true;
        } else {
            enableJunc = false;
        }
    }//GEN-LAST:event_EnableJunctionsActionPerformed

    private void AboutJunctionsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_AboutJunctionsActionPerformed
        JOptionPane.showMessageDialog(this,
            "Junctions create a link (NTFS Junction Point) from one folder to another folder.\n\n" +
            "To delete a junction, go to SoundtrackMusic and manually delete it.\n\n" +
            "WARNING: When deleteing a Junction Point or a folder containing a Junction Point\n" +
            "in Windows XP, ALWAYS use Shift+Del to safely delete the link. If not, it is\n" +
            "possible to delete the linked folder, and thus the music inside of the folder.\n\n" +
            "For more information, see:\n" +
            "http://en.wikipedia.org/wiki/NTFS_junction_point",
            "About Junctions", JOptionPane.PLAIN_MESSAGE);
    }//GEN-LAST:event_AboutJunctionsActionPerformed

    private void AddFileActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_AddFileActionPerformed
        JFileChooser jf = new JFileChooser();
        jf.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        jf.setMultiSelectionEnabled(true);
        if(curAddDir == null){
            jf.setCurrentDirectory(curAddDir);
        }
        int returnVal = jf.showOpenDialog(this);
        curAddDir = jf.getCurrentDirectory();
        File[] files = jf.getSelectedFiles();

        st.resetCounts();
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            for (int i = 0; i < files.length; i++){
                File f = files[i];
                String srcpath = f.getPath();
                String musFileName = f.getName();
                String destpath = st.getMusicDir().getPath() + "\\" + musFileName;
                st.CopyAddFiles(srcpath, destpath);
            }
        }
        st.Log("Summary: Added " + st.getmp3count() + " mp3 file(s).\n");
    }//GEN-LAST:event_AddFileActionPerformed

    private void DeleteFileActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_DeleteFileActionPerformed
        JFileChooser jf = new JFileChooser();
        jf.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        jf.setMultiSelectionEnabled(true);
        jf.setCurrentDirectory(st.getMusicDir());
        int returnVal = jf.showOpenDialog(this);
        File[] files = jf.getSelectedFiles();

        st.resetCounts();
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            for (int i = 0; i < files.length; i++){
                File f = files[i];
                String musFileName = f.getName();
                String destpath = st.getMusicDir().getPath() + "\\" + musFileName;
                st.DeleteFiles(destpath);
            }
        }
        
        st.Log("Summary: Deleted " + st.getmp3count() + " mp3 file(s).\n");
    }//GEN-LAST:event_DeleteFileActionPerformed

    private void DeleteFolderActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_DeleteFolderActionPerformed
        JFileChooser jf = new JFileChooser();
        jf.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        jf.setMultiSelectionEnabled(true);
        jf.setCurrentDirectory(st.getMusicDir());
        int returnVal = jf.showOpenDialog(this);
        File[] files = jf.getSelectedFiles();

        st.resetCounts();
        int junccount = 0;
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            for (int i = 0; i < files.length; i++){
                if(files[i].getName().contains("j-") || files[i].getName().contains("junction-")){
                    boolean deleted = files[i].delete();
                    junccount++;
                } else{
                    File f = files[i];
                    String musDirName = f.getName();
                    File destpath = new File(st.getMusicDir().getPath() + "\\" + musDirName);
                    //JOptionPane.showMessageDialog(this, "Deleting " + destpath);
                    st.DeleteFiles(destpath.getPath());
                    destpath.delete();
                }
            }
        }

        st.Log("Summary: Deleted " + junccount + " junction(s).");
        st.Log("Summary: Deleted " + st.getmp3count() + " mp3 file(s).\n");
    }//GEN-LAST:event_DeleteFolderActionPerformed

    private void CreateSoundtrackMusicActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_CreateSoundtrackMusicActionPerformed
        st.CopyAddFiles(st.getAddonDir().getPath() + "\\SoundtrackMusic", st.getMusicDir().getPath());
    }//GEN-LAST:event_CreateSoundtrackMusicActionPerformed

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new SoundtrackMusicGUI().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem AboutJunctions;
    private javax.swing.JMenuItem AddFile;
    private javax.swing.JMenuItem AddFolder;
    private javax.swing.JMenuItem CreateSoundtrackMusic;
    private javax.swing.JMenuItem DeleteFile;
    private javax.swing.JMenu DeleteFiles;
    private javax.swing.JMenuItem DeleteFolder;
    private javax.swing.JCheckBoxMenuItem EnableJunctions;
    private javax.swing.JMenuItem ExitManager;
    private javax.swing.JSeparator FileMenuSeparator;
    private javax.swing.JMenu HelpMenu;
    private javax.swing.JMenuBar MenuBar;
    private javax.swing.JMenu OptionsMenu;
    private javax.swing.JScrollPane ScrollPanel;
    private javax.swing.JTextArea TextArea;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    // End of variables declaration//GEN-END:variables

}
